<?php


namespace App\Constants;

use App\Models\CourseLevel;

class Constant
{


    const FALSE = "false";
    //questions


    // Global Constant
    const UN_DEFINED = "un-defined";
    const ACTIVE = 'active';
    const IN_ACTIVE = 'in-active';
    const MALE = 'male';
    const FEMALE = 'female';
    const PENDING = 'pending';
    const CONFIRMED = 'confirmed';
    const REJECTED = 'rejected';

    const DRAFT = 'draft';
    const PUBLISHED = 'published';


    // categories entities
    const POST = 'post';
    const SHOP = 'shop';


    // File Constant
    const IMAGE = 'image';
    const SOUND = 'sound';
    const VIDEO = 'video';

    const WHITE_MIME_TYPE_LIST = [
        'image/jpeg', 'image/png', 'image/jpg', 'audio/mpeg', 'video/mp4',
        'application/zip', 'application/vnd.ms-powerpoint',
        'application/vnd.openxmlformats-officedocument.presentationml.presentation',
        'application/vnd.rar', 'text/plain', 'application/vnd.ms-excel',
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    ];


    const PRODUCT_AVATAR_SIZE = [
        '100' => ['w' => '100', 'h' => '100'],
        '300' => ['w' => '300', 'h' => '300']
    ];
    const USER_AVATAR_SIZE = [
        '100' => ['w' => '200', 'h' => '200'],
    ];

    // products
    const PRODUCT_IMAGE_PATH = 'uploads' . DIRECTORY_SEPARATOR . 'products' . DIRECTORY_SEPARATOR . 'image' . DIRECTORY_SEPARATOR . '';
    const PRODUCT_VIDEO_PATH = 'uploads' . DIRECTORY_SEPARATOR . 'products' . DIRECTORY_SEPARATOR . 'video' . DIRECTORY_SEPARATOR . '';
    const PRODUCT_GALLERY_PATH = 'uploads' . DIRECTORY_SEPARATOR . 'products' . DIRECTORY_SEPARATOR . 'gallery' . DIRECTORY_SEPARATOR . '';

    // categories
    const CATEGORY_IMAGE_PATH = 'uploads' . DIRECTORY_SEPARATOR . 'categories' . DIRECTORY_SEPARATOR . 'image' . DIRECTORY_SEPARATOR . '';


    // admins
    const ADMINS_IMAGE_PATH = 'uploads' . DIRECTORY_SEPARATOR . 'admins' . DIRECTORY_SEPARATOR . 'image' . DIRECTORY_SEPARATOR . '';


    // users
    const USERS_AVATAR_PATH = 'uploads' . DIRECTORY_SEPARATOR . 'users' . DIRECTORY_SEPARATOR . 'image' . DIRECTORY_SEPARATOR . '';

    // posts
    const POSTS_AVATAR_PATH = 'uploads' . DIRECTORY_SEPARATOR . 'posts' . DIRECTORY_SEPARATOR . 'image' . DIRECTORY_SEPARATOR . '';
    // product
    const PRODUCT_AVATAR_PATH = 'uploads' . DIRECTORY_SEPARATOR . 'products' . DIRECTORY_SEPARATOR . 'image' . DIRECTORY_SEPARATOR . '';



    public static function getStatuses($status = null)
    {
        if (is_null($status)) {
            return [
                Constant::ACTIVE => 'موجود',
                Constant::IN_ACTIVE => ' غیر موجود ',
            ];
        }
        if (in_array($status, array_keys(self::getStatuses()))) {
            return self::getStatuses()[$status];
        }
        return Constant::UN_DEFINED;
    }

    public static function getStatusesViewer()
    {
        $activeStatuses = self::getStatuses();
        $activeStatusesViewer = [];
        foreach ($activeStatuses as $key => $value) {
            $activeStatusesViewer[] = [
                'id' => $key,
                'title' => $value
            ];
        }
        return $activeStatusesViewer;
    }


    // category entities
    public static function getCategoryEntities($status = null)
    {
        $categoryEntities = [
            self::POST => 'مقالات',
            self::SHOP => 'فروشگاه',

        ];
        if (is_null($status)) {
            return $categoryEntities;
        }
        if (in_array($status, array_keys($categoryEntities))) {
            return $categoryEntities[$status];
        }
    }

    public static function getCategoryEntitiesView(): array
    {
        $categoryEntities = self::getCategoryEntities();
        $categoryEntitiesView = [];
        foreach ($categoryEntities as $key => $value) {
            $categoryEntitiesView[] = [
                'id' => $key,
                'title' => $value
            ];
        }
        return $categoryEntitiesView;
    }

    // post statuses
    public static function getPostStatuses($status = null)
    {
        $postStatuses = [
            self::PUBLISHED => 'تایید شده',
            self::DRAFT => 'رد شده  ',
        ];
        if (is_null($status)) {
            return $postStatuses;
        }
        if (in_array($status, array_keys($postStatuses))) {
            return $postStatuses[$status];
        }
    }

    public static function getPostStatusesView(): array
    {
        $postStatuses = self::getPostStatuses();
        $postStatusesView = [];

        foreach ($postStatuses as $key => $value) {
            $postStatusesView[] = [
                'id' => $key,
                'title' => $value
            ];
        }
        return $postStatusesView;

    }

    public static function getStatusComments($status = null)
    {
        $categoryEntities = [
            self::CONFIRMED => 'تایید شده',
            self::PENDING => 'در انتظار تایید',
            self::REJECTED => 'رد شده',

        ];
        if (is_null($status)) {
            return $categoryEntities;
        }
        if (in_array($status, array_keys($categoryEntities))) {
            return $categoryEntities[$status];
        }
    }

    public static function getStatusCommentsView(): array
    {
        $statusComments = self::getStatusComments();
        $statusCommentsView = [];
        foreach ($statusComments as $key => $value) {
            $statusCommentsView[] = [
                'id' => $key,
                'title' => $value
            ];
        }
        return $statusCommentsView;
    }


}
