<?php

namespace App\Http\Controllers\Admin;

use App\Filters\CategoriesFilter;
use App\Http\Requests\Category\StoreCategoryRequest;
use App\Http\Requests\Category\UpdateCategoryRequest;
use App\Models\Category;
use App\Constants\Constant;
use App\Models\Like;
use App\Models\Post;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class CategoriesController extends BaseController
{
    private $entity = 'all';

    public function __construct()
    {

        if (!is_null(request('entity')) && in_array(request('entity'), [ 'post','products'])) {
            $this->entity = request('entity');
        }

    }


    public function index($entity)
    {

        $categoriesListBuilder = Category::filter(new CategoriesFilter());
        if ($this->entity != 'all') {
            $categoriesList = $categoriesListBuilder->where('entity', $this->entity)->get();
        } else {
            $categoriesList = $categoriesListBuilder->get();
        }


        $categories = $categoriesList->groupBy('parent_id');
        if (isset($categories[""])) {
            $categories["root"] = $categories[""];
            unset($categories[""]);
        }

        return view('admin.categories.all', [
            'categories' => $categories,
            'entity' => $this->entity,
        ]);
    }

    public function create($entity)
    {
        $activityStatuses = Constant::getStatusesViewer();
        $entities = Constant::getCategoryEntitiesView();
        $entity = $this->entity;
        return view('admin.categories.create', compact("activityStatuses", "entities", "entity"));

    }

    public function store(StoreCategoryRequest $request, $entity)
    {
        if (request('entity') == "all") {
            $isValidEntity = $this->isValidEntity();
            if ($isValidEntity == "false") {
                return redirect()->back()->with('error', 'بخش مربوط انتخاب شده معتبر نمیباشد');
            }
        }

        $data = $this->getData();
        $category = Category::create($data);
        if ($category instanceof Category) {
            return redirect()->route("admin.categories.all", $entity)->with("store", "دسته بندی شما با موفقیت ثبت شد");
        }
        return redirect()->back();
    }

    public function edit($entity, Category $category)
    {

        $entities = Constant::getCategoryEntitiesView();
        $activityStatuses = Constant::getStatusesViewer();
        return view('admin.categories.edit', compact('category', 'activityStatuses', 'entities', 'entity'));
    }

    public function update(UpdateCategoryRequest $request, $entity, Category $category)
    {

        if (request('entity') == "all") {
            $isValidEntity = $this->isValidEntity();
            if ($isValidEntity == "false") {
                return redirect()->back()->with('error', 'بخش مربوط انتخاب شده معتبر نمیباشد');
            }
        }

        $data = $this->getData();
        $result = $category->update($data);

        if ($result) {
            return redirect()->route('admin.categories.all', ['entity' => request('entity')])->with("update", "دسته بندی شما با موفقیت ویرایش شد");
        }
        return redirect()->back();
    }

    public function delete($entity, Category $category)
    {

        $category->delete();
        return redirect()->back()->with("delete", "دسته بندی شما با موفقیت حذف شد");
    }

    public function ajaxSearch()
    {
        $entity = request('entity');
        $title = request('q');

        $categoriesBuilder = Category::where('title', 'like', "%$title%");
        if ($entity != 'all') {
            $output = $categoriesBuilder->where('entity', $entity)->get([
                'id as id',
                'title as name'
            ])->toArray();
        } else {
            $output = $categoriesBuilder->get([
                'id as id',
                'title as name'
            ])->toArray();
        }
        return response()->json(['data' => $output]);
    }

    public function getData()
    {
        $data = [
            "title" => request('title'),
            "parent_id" => request('parent'),
            "description" => request('description'),
            "status" => request('status'),

        ];
        if (request()->hasFile('avatar')) {
            $data['avatar'] = $this->uploadFile(request()->file('avatar'), Constant::CATEGORY_IMAGE_PATH);
        }
        if (request('entity') == "all") {
            $data['entity'] = request('part_entity');
        } else {
            $data['entity'] = request('entity');
        }
        return $data;
    }

    public function isValidEntity()
    {

        if (!is_null(request('parent'))) {
            $parentEntity = Category::where('id', request('parent'))->first('entity');
            if ($parentEntity->entity == request('part_entity')) {
                return "true";
            } else {
                return "false";
            }
        }
    }
}
