<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Tag;
use Illuminate\Http\Request;

class TagsController extends Controller
{
    public function index()
    {
        $tags = Tag::paginate();
        return view('admin.tags.all', compact('tags'));
    }

    public function store()
    {

        // validate request
        request()->validate([
            'name' => ['required', 'unique:tags'],
        ]);

        // store tag
        $tag = Tag::create([
            'name' => request('name'),
        ]);

        // redirect
        if ($tag instanceof Tag) {
            return redirect()->route('admin.tags.all')->with('success', 'ثبت تگ با موفقیت انجام شد');
        }
        return redirect()->route('admin.tags.all')->with('failed', 'خطا در ثبت اطلاعات');

    }

    public function edit(Tag $tag)
    {
        $tags = Tag::paginate();
        return view('admin.tags.edit', compact('tags', 'tag'));
    }

    public function update(Tag $tag)
    {
        request()->validate([
            'name' => ['required'],
        ]);

        $tag->update([
            'name' => request('name')
        ]);

        return redirect()->route('admin.tags.all')->with('success', 'تگ با موفقیت ویرایش شد');
    }

    public function delete(Tag $tag)
    {
        $tag->delete();
        return redirect()->back();
    }

    public function searchWithAjax()
    {
        $q = request('q');

        $tags = Tag::select(['id', 'name'])
            ->where('name', 'like', "%$q%")
            ->get();

        return response()->json(['data' => $tags]);

    }

}
