<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Unit;
use Illuminate\Http\Request;

class UnitsController extends BaseController
{
    public function index(): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {
        $units = Unit::all();
        return view('admin.units.all', compact('units'));
    }

    public function create(): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {
        return view('admin.units.create');
    }

    public function store(Request $request): \Illuminate\Http\RedirectResponse
    {
        $data = $request->validate([
            'name'      => 'required|string|max:255',
            'base_unit' => 'required|in:gram,count,liter',
        ]);

        Unit::query()->create([
            'name'      => $data['name'],
            'base_unit' => $data['base_unit'],
        ]);

        return redirect()->route('admin.units.all')->with('success', 'واحد با موفقیت ایجاد شد');
    }

    public function edit(Unit $unit): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {
        $units = Unit::all();
        return view('admin.units.edit', compact('unit','units'));
    }

    public function update(Request $request, Unit $unit): \Illuminate\Http\RedirectResponse
    {
        $data = $request->validate([
            'name'      => 'required|string|max:255',
            'base_unit' => 'required|in:gram,count,liter',
        ]);

        $unit->update([
            'name'      => $data['name'],
            'base_unit' => $data['base_unit'],
        ]);

        return redirect()->route('admin.units.all')->with('success', 'واحد بروزرسانی شد');
    }

    public function delete(Unit $unit): \Illuminate\Http\RedirectResponse
    {
        $unit->delete();

        return back()->with('success', 'واحد حذف شد');
    }
}
