<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Unit;
use App\Models\UnitValue;
use Illuminate\Http\Request;

class UnitsValueController extends Controller
{
    public function index(): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {
        $unitValues = UnitValue::with('unit')->latest()->get();
        $units = Unit::all();
        return view('admin.unit-values.all', compact('unitValues','units'));
    }


    public function store(Request $request): \Illuminate\Http\RedirectResponse
    {
        $data = $request->validate([
            'unit_id' => 'required|exists:units,id',
            'title'   => 'required|string|max:255',
            'value'   => 'nullable|numeric|min:0',
        ]);

        UnitValue::query()->create($data);

        return redirect()->route('admin.UnitsValue.all')
            ->with('success', 'مقدار واحد با موفقیت ایجاد شد');
    }

    public function edit(UnitValue $unitValue): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {
        $units = Unit::all();
        return view('admin.unit-values.edit', compact('unitValue', 'units'));
    }

    public function update(Request $request, UnitValue $unitValue): \Illuminate\Http\RedirectResponse
    {
        $data = $request->validate([
            'unit_id' => 'required|exists:units,id',
            'title'   => 'required|string|max:255',
            'value'   => 'nullable|numeric|min:0',
        ]);

        $unitValue->update($data);

        return redirect()->route('admin.UnitsValue.all')->with('success', 'مقدار واحد بروزرسانی شد');
    }

    public function delete(UnitValue $unitValue): \Illuminate\Http\RedirectResponse
    {

        $unitValue->delete();

        return back()->with('success', 'مقدار واحد حذف شد');
    }
}
