<?php

namespace App\Http\Controllers\Auth\app;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
class RegisterController extends Controller
{
    public function showRegisterForm(): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {
        return view('auth.app.register');
    }

    public function register(Request $request): \Illuminate\Http\RedirectResponse
    {

         // validate request
         $this->validateStoreUser();

         // prepare data to insert in db
         $data = $this->getData();

         // create new user
         $user = User::query()->create($data);

         // redirect
         if ($user instanceof User) {
            //login user
            Auth::guard('web')->login($user);
             return redirect()->route('app.index');
         }
         return redirect()->back();

    }

    private function validateStoreUser()
    {

        request()->validate([

            'password' => ['required'],
            'full_name' => ['required'],
            'mobile' => ['required', 'unique:users'],

        ], [

            'password.required' => "رمز عبور خود را وارد نمائید",
            'mobile.required' => "شماره موبایل خودرا وارد نمایید" ,
            'mobile.unique' => 'شماره موبایل  وارد شده قبلا ثبت شده است',
            'full_name.required' => " نام ونام خانوادگی  خود را وارد نمائید",
        ]);

    }
    private function getData(): array
    {
        $data = [

            'mobile' => request('mobile'),
            'full_name' => request('full_name'),
            'password' => Hash::make(request('password')),

        ];
        return $data;
    }


}
