<?php

namespace App\Http\Controllers\Frontend;

use App\Exceptions\ProductQuantityException;
use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Support\Basket\Basket;
use App\Support\Storage\Contracts\StorageInterface;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;


class BasketController extends Controller
{
    private Basket $basket;

    public function __construct(Basket $basket)
    {
        $this->basket = $basket;

    }

    public function index(): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {

        $items = $this->basket->all();

        return view('app.basket', compact('items'));
    }

    public function add(Product $product): JsonResponse
    {

        try {

            $this->basket->add($product, 1);

            return response()->json([
                'status' => 'success',
                'total_discount' => number_format($this->basket->subTotalDiscount()) . ' تومان ',
                'total_price' => number_format($this->basket->subTotalPrice()) . ' تومان ',
                'payable_price' => number_format($this->basket->subPayablePrice()) . ' تومان ',
                'message' => 'محصول با موفقیت به سبد خرید شما اضافه شد',
            ]);

        } catch (ProductQuantityException $exception) {

            return response()->json([
                'status' => 'failed',
                'message' => 'موجودی محصول کافی نمیباشد',
            ]);
        }
    }

    public function remove(Product $product): JsonResponse
    {
        $this->basket->remove($product);

        return response()->json([
            'status' => 'success',
            'total_discount' => number_format($this->basket->subTotalDiscount()) . ' تومان ',
            'total_price' => number_format($this->basket->subTotalPrice()) . ' تومان ',
            'payable_price' => number_format($this->basket->subPayablePrice()) . ' تومان ',
            'message' => 'محصول مورد نظر از سبد خرید حذف شد',
        ]);
    }

    public function clear(): RedirectResponse
    {
        resolve(StorageInterface::class)->clear();

        return redirect()->back();
    }
    public function factor(): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {
          $items = $this->basket->all();

        return view('app.factor', compact('items'));
    }
}
