<?php

namespace App\Models;

use App\Constants\Constant;
use App\Filters\Contracts\Filterable;
use App\Presenters\Contracts\Presentable;
use App\Presenters\Web\Category\CategoryPresenter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;
use App\Models\Product;
class Category extends Model
{
    use HasFactory, Presentable, SoftDeletes,Filterable,Sluggable;

    protected $guarded = ['id'];

    protected $webPresenter = CategoryPresenter::class;

    public function parent()
    {
        return $this->belongsTo(Category::class,'parent_id', 'id');
    }
    public function children()
    {
        return $this->hasMany(Category::class, 'parent_id', 'id');
    }
    public function products()
    {

        return $this->morphedByMany(Product::class,'categoriable');


    }
    public function posts()
    {

        return $this->morphedByMany(Post::class,'categoriable');


    }
    public static function buildChildren($categories, $child_category, $selectedCategoriesIDs = null)
    {

        $temp_children = [];

        if (isset($categories[$child_category->id])) {
            foreach ($child_category->children as $child_category) {

                $temp = [
                    'id' => $child_category->id,
                    'text' => $child_category->title,
                ];

                if (isset($categories[$child_category->id])) {
                    $temp['icon'] = 'la la-angle-double-down text-warning';
                    $temp['state']['opened'] = true;
                    $temp['children'] = self::buildChildren($categories, $child_category, $selectedCategoriesIDs);
                } else $temp['icon'] = 'la la-check text-success';

                if (!is_null($selectedCategoriesIDs) && in_array($child_category->id, $selectedCategoriesIDs)) {
                    $temp['state']['selected'] = true;
                }

                $temp_children[] = $temp;
            }
            return $temp_children;
        }
    }
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title',
                 'onUpdate' => true,

            ]
        ];
    }

}
