<?php

namespace App\Models;

use App\Constants\Constant;
use App\Presenters\Contracts\Presentable;
use App\Presenters\Web\Comment\CommentPresenter as WebCommentPresenter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{
    use HasFactory,Presentable;

    protected $guarded = ['id'];
    protected $webPresenter = WebCommentPresenter::class;

    public function commentable()
    {
        return $this->morphTo();
    }
    public static function getEntity($entity = null)
    {

        if(!is_null($entity) && in_array($entity,['post','shop']))
        {
            return [
                Constant::POST => Post::class,
                Constant::SHOP => Product::class,
            ][$entity];
        }

    }

    public function user(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(User::class);
    }


}
