<?php

namespace App\Models;

use App\Constants\Constant;
use App\Filters\Contracts\Filterable;
use App\Presenters\Contracts\Presentable;
use App\Presenters\Web\File\FilePresenter as WebFilePresenter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;

class File extends Model
{
    use HasFactory, Filterable, Presentable;

    protected $webPresenter = WebFilePresenter::class;
    protected $guarded = ['id'];


    public static function getFileType(UploadedFile $uploadedFile)
    {

        if (!in_array($uploadedFile->getClientMimeType(), Constant::WHITE_MIME_TYPE_LIST))
           return null ;

        return [
            'image/jpeg' => Constant::IMAGE,
            'image/png' => Constant::IMAGE,
            'image/jpg' => Constant::IMAGE,
            'audio/mpeg' => Constant::SOUND,
            'video/mp4' => Constant::VIDEO,
        ][$uploadedFile->getClientMimeType()];

    }

}
