<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;
use App\Filters\Contracts\Filterable;
use App\Presenters\Contracts\Presentable;
use App\Presenters\Web\Product\ProductPresenter;
/**
 * @property int $id
 * @property int $quantity
 */
class Product extends Model
{
    use HasFactory, Presentable, Filterable, SoftDeletes,Sluggable;

    protected $guarded = ['id'];

    protected $webPresenter = ProductPresenter::class;

    public function tags(): \Illuminate\Database\Eloquent\Relations\MorphToMany
    {
        return $this->morphToMany(Tag::class, 'taggable');
    }

    public function categories(): \Illuminate\Database\Eloquent\Relations\MorphToMany
    {
        return $this->morphToMany(Category::class, 'categoriable');
    }
    public function comments(): \Illuminate\Database\Eloquent\Relations\MorphMany
    {
        return $this->morphMany(Comment::class, 'commentable');
    }
    public function files(): \Illuminate\Database\Eloquent\Relations\MorphToMany
    {
        return $this->morphToMany(File::class, 'fileble');
    }

    public function unitPrices(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(ProductUnitPrice::class);
    }

    public function sluggable(): array
    {
        return [
            'slug' => ['source' => 'title', 'onUpdate' => true,]
        ];
    }
}
