<?php


namespace App\Presenters\Web\Category;


use App\Constants\Constant;
use App\Presenters\Contracts\Presenter;

class CategoryPresenter extends Presenter
{
    public function avatar()
    {

        if (is_null($this->entity->avatar) || $this->entity->avatar == "") {
            return asset('admin-assets/media/avatars/blank.png');
        }
        return str_replace('\\', '/', asset(Constant::CATEGORY_IMAGE_PATH . DIRECTORY_SEPARATOR . $this->entity->avatar));
    }

    public function status()
    {

        if (!is_null($this->entity->status) && $this->entity->status == Constant::ACTIVE) {
            return "<span class='badge badge-light-success'>" . Constant::getStatuses($this->entity->status) . "</span>";
        } elseif ($this->entity->status == "in-active") {
            return "<span class='badge badge-light-danger'>" . Constant::getStatuses($this->entity->status) . "</span > ";
        }
    }

    public function parent()
    {
        if (!is_null($this->entity->parent_id)) {
            return "<small class='badge badge-light-info' > {$this->entity->parent->title} </small > ";
        }

        return "<small class='badge badge-light-danger' > ندارد</small > ";
    }

    public function entity()
    {
        $entity = "";
        if (!is_null($this->entity->entity)) {

            switch ($this->entity->entity) {

                case Constant::POST:
                    $entity = "<span class='badge badge-light-warning' > " . Constant::getCategoryEntities($this->entity->entity) . "</span > ";
                    break;
                case Constant::SHOP:
                    $entity = "<span class='badge badge-light-danger' > " . Constant::getCategoryEntities($this->entity->entity) . "</span > ";
                    break;

            }
        }
        return $entity;
    }
}
