<?php


namespace App\Presenters\Web\Comment;


use App\Constants\Constant;
use App\Presenters\Contracts\Presenter;

class CommentPresenter extends Presenter
{


    public function status()
    {

        if ($this->entity->status == Constant::PENDING) {
            return " <div class='badge badge-light-warning'>در انتظار تایید</div>";
        } elseif ($this->entity->status == Constant::CONFIRMED) {
            return "  <div class='badge badge-light-success'>تایید شده</div>";
        } elseif ($this->entity->status == Constant::REJECTED) {
            return "  <div class='badge badge-light-danger'>رد شده</div>";
        }
    }

    public function user()
    {

        return $this->entity->user->first_name . ' ' . $this->entity->user->last_name;
    }

    public function type()
    {

        if ($this->entity->commentable_type == Constant::POST) {
            return " <div class='badge badge-light-info'>وبلاگ</div>";
        } elseif ($this->entity->commentable_type == Constant::SHOP) {
            return "  <div class='badge badge-light-primary'> محصول </div>";
        }
    }


}
