<?php


namespace App\Presenters\Web\Product;


use App\Constants\Constant;
use App\Models\User;
use App\Presenters\Contracts\Presenter;
use Illuminate\Support\Facades\DB;

class ProductPresenter extends Presenter
{
    public function image()
    {

        if (is_null($this->entity->image) || $this->entity->image == "") {
            return asset('admin-assets/media/avatars/blank.png');
        }
        return str_replace('\\', '/', asset(Constant::PRODUCT_AVATAR_PATH . DIRECTORY_SEPARATOR . $this->entity->image));
    }
    public function image2()
    {

        if (is_null($this->entity->image2) || $this->entity->image2 == "") {
            return asset('admin-assets/media/avatars/blank.png');
        }
        return str_replace('\\', '/', asset(Constant::PRODUCT_AVATAR_PATH . DIRECTORY_SEPARATOR . $this->entity->image2));
    }



    public function status()
    {
        $status = "";
        if (!is_null($this->entity->status)) {
            if ($this->entity->status == Constant::ACTIVE) {
                return " <div class='badge badge-light-success'>  موجود</div>";
            } elseif ($this->entity->status == Constant::IN_ACTIVE) {
                return "  <div class='badge badge-light-danger'> غیر موجود  </div>";
            }
        }
        return $status;
    }




}
