<div id="kt_leaflet_{{$name}}" style="height:300px "></div>

<input id="lng_{{$name}}" name="{{$name}}[lng]"
       class="form-control form-control-lg form-control-solid"
       type="hidden"
       @if(isset($value['lng']))
            value="{{  $value['lng']  }}"
        @endif
>
<input id="lat_{{$name}}" name="{{$name}}[lat]"
       class="form-control form-control-lg form-control-solid"
       type="hidden"
       @if(isset($value['lat']))
            value="{{  $value['lat']   }}"
        @endif
>


<script>

    // Class definition
    // Define Map Location
    var leaflet = L.map('kt_leaflet_{{$name}}').setView([32.313, 50.563], 4.5);

    /*var leaflet = L.map('kt_leaflet_5', {
        center: [40.725, -73.985],
        zoom: 13
    });*/

    // Init Leaflet Map
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
    }).addTo(leaflet);

    // Set Geocoding
    var geocodeService;
    if (typeof L.esri.Geocoding === 'undefined') {
        geocodeService = L.esri.geocodeService();
    } else {
        geocodeService = L.esri.Geocoding.geocodeService();
    }

    // Define Marker Layer
    var markerLayer = L.layerGroup().addTo(leaflet);

    // Set Custom SVG icon marker
    var leafletIcon = L.divIcon({
        html: `<span class="svg-icon svg-icon-danger svg-icon-3x"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="24" width="24" height="0"/><path d="M5,10.5 C5,6 8,3 12.5,3 C17,3 20,6.75 20,10.5 C20,12.8325623 17.8236613,16.03566 13.470984,20.1092932 C12.9154018,20.6292577 12.0585054,20.6508331 11.4774555,20.1594925 C7.15915182,16.5078313 5,13.2880005 5,10.5 Z M12.5,12 C13.8807119,12 15,10.8807119 15,9.5 C15,8.11928813 13.8807119,7 12.5,7 C11.1192881,7 10,8.11928813 10,9.5 C10,10.8807119 11.1192881,12 12.5,12 Z" fill="#000000" fill-rule="nonzero"/></g></svg></span>`,
        bgPos: [10, 10],
        iconAnchor: [20, 37],
        popupAnchor: [0, -37],
        className: 'leaflet-marker'
    });

    @if(isset($value['lng']) && isset($value['lat']))
        L.marker([{{$value['lng']}}, {{$value['lat']}}], {icon: leafletIcon}).addTo(leaflet);
    @endif

    leaflet.on('click', function (e) {
        markerLayer.clearLayers();
        var marker = L.marker(e.latlng, { icon: leafletIcon }).addTo(markerLayer).bindPopup("موقعیت جغرافیایی", { closeButton: false }).openPopup()
        $("#lat_{{$name}}").val(e.latlng.lat)
        $("#lng_{{$name}}").val(e.latlng.lng)
        <!-- L.marker(e.latlng, { icon: leafletIcon }).addTo(markerLayer).bindPopup("لوکیشن", { closeButton: true }).openPopup(); -->
    });
</script>
