@extends('layouts.admin.admin')
@section('content')
    <div class="d-flex flex-end mb-5">
        <button type="button" class="btn  btn-primary px-4 py-2 ml-4" data-bs-toggle="collapse"
                href="#student_filters" role="button"
                aria-expanded="false" aria-controls="collapseExample" style="margin-left: 5px!important;">
            فیلتر
            <i class="fa fa-filter p-0 m-0"></i>
        </button>
    </div>
    <div class="card mb-5 pb-3 mb-xl-8 collapse @if(request()->has('title')) show @else @endif" id="student_filters">
        <form action="" class="form remove-empty-values" method="get" id="remove-empty-values">
            <!--begin::Header-->
            <div class="card-header border-0 pt-5">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder fs-3 mb-1">
                        <i class="fa fa-search text-white pl-1"></i>
                        جستجوی پیشرفته
                    </span>
                </h3>
            </div>
            <div class="card-body py-3">
                <div class="row">
                    <div class="col-lg-3 col-md-3 col-sm-12">
                        <div class="form-group">
                            <label class="form-label fs-6 fw-bolder text-dark">جستجو بر اساس عنوان
                            </label>
                            <input class="form-control form-control-lg form-control-solid" name="title"
                                   placeholder=""
                                   value="{{ request()->has('title') ? request()->get('title') : null }}"/>
                        </div>
                    </div>

                </div>
                <br/>
                <div class="d-flex  flex-end">
                    <a href="{{route('admin.categories.all', $entity)}}" class="btn btn-sm btn-light-danger mx-1">
                        <i class="fa fa-eraser p-0 m-0"></i>
                        حذف فیلترها
                    </a>
                    <button type="submit" class="btn btn-sm btn-light-primary mx-1">
                        <i class="fa fa-search"></i>
                        فیلتر
                    </button>
                </div>
            </div>
        </form>
    </div>
    <div class="card mb-5 mb-xl-8 mt-15">
        <!--begin::Header-->
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">فهرست دسته بندی </span>
            </h3>
            <div class="card-toolbar">

                <a href="{{route('admin.categories.create',$entity)}}" class="btn btn-sm btn-light-success">
                    ثبت دسته بندی جدید
                </a>


            </div>
        </div>

        <!--end::Header-->
        <!--begin::Body-->
        <div class="card-body py-3">
            <!--begin::Table container-->
            <div class="table-responsive">
                <!--begin::Table-->
                <table class="table align-middle gs-0 gy-4">
                    <!--begin::Table head-->
                    <thead>
                    <tr class="fw-bolder text-muted bg-light">

                        <th class="ps-4  rounded-start">عنوان دسته بندی</th>
                        <th class="min-w-100px">والد</th>
                        <th class="min-w-100px">بخش</th>
                        <th class="min-w-100px">وضعیت</th>
                        <th class="min-w-100px ">تنظیمات</th>
                    </tr>
                    </thead>
                    <!--end::Table head-->
                    <!--begin::Table body-->
                    <tbody>

                    @if(!is_null($categories) && isset($categories['root']))
                        @include('admin.categories.list', ['items' => $categories['root'] ])
                    @else
                        <tr>
                            <td colspan="4" class="text-center">
                                <h4 class="text-danger pt-5">دسته بندی ثبت نشده است</h4>
                            </td>
                        </tr>
                    @endif
                    </tbody>
                    <!--end::Table body-->
                </table>
                <!--end::Table-->

            </div>
            <!--end::Table container-->
        </div>
        <!--begin::Body-->
    </div>
@endsection
@section('style')
   <style>
       #cart-category-create-form{
           z-index: unset !important;
       }
   </style>
@endsection
@section('scripts')
    @include('admin.message.alert');
    <script>
        $('#remove-empty-values').submit(function () {
            $(this).find(':input').filter(function () {
                return !this.value;
            }).attr('disabled', 'disabled');
            return true;
        });
    </script>
    <script>

        $('.delete-confirm').on('click', function (event) {
            event.preventDefault();
            let category = $(this).data("id");
            let entity = "{{ $entity }}";
            let url = "{{ route('admin.categories.delete',[":entity", ":category"]) }}";
            url = url.replace(":category", category);
            url = url.replace(":entity", entity);

            Swal.fire({
                title: 'حذف  !',
                text: "آیا مطمئن هستید ؟",
                icon: "error",
                showCancelButton: true,
                confirmButtonColor: 'red',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'بله,حذف کن',
                cancelButtonText: 'خیر',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>
@endsection
