@extends('layouts.admin.admin')
@section('title','مدیریت دسته بندی ها')
@section('pageTitle','ویرایش دسته بندی جدید')
@section('content')
<!--begin::Tables Widget 11-->
<div id="kt_content_container" class="container-xxl">
    <form id="kt_ecommerce_add_category_form"
          class="form d-flex flex-column flex-lg-row fv-plugins-bootstrap5 fv-plugins-framework"
          data-kt-redirect="" action="{{route('admin.categories.update',[$entity,$category])}}" method="post" enctype="multipart/form-data">
    @csrf
    <!--begin::Main column-->
        <div class="d-flex flex-column flex-row-fluid gap-7 gap-lg-10" style="margin-left: 20px ">
            <!--begin::General options-->
            <div class="card card-flush py-4">
                <!--begin::Card header-->
                <div class="card-header">
                    <div class="card-title">
                        <h2>ویرایش دسته بندی</h2>
                    </div>
                    <div class="card-toolbar">
                        <a href="{{route('admin.categories.all',$entity)}}" class="btn btn-sm btn-light-success "
                           style="margin-left: 5px">
                           بازگشت
                        </a>

                    </div>
                </div>
                <!--end::Card header-->
                <!--begin::Card body-->
                <div class="card-body pt-0 mt-2">
                    <div class="row">
                        <div class="col-md-6">
                            <!--begin::Label-->
                            <label class="required form-label">عنوان دسته بندی </label>
                            <!--end::Label-->
                            <!--begin::Input-->
                            @include('admin.__components.input-text', [ 'name' => 'title', 'value' => $category->title ])
                            <!--end::Input-->
                            <!--begin::Description-->

                            <!--end::Description-->
                            <div class="fv-plugins-message-container invalid-feedback"></div>
                        </div>
                        @if($entity == "all")
                        <div class="col-md-6">
                            @include('admin.__components.label', [ 'title' => 'بخش','required' => 1])
                            @include('admin.__components.select-2', [
                                'name' => 'part_entity',
                                'items' => $entities,
                                'selectedItems' => [$category->entity]
                                ])
                            <div class="fv-plugins-message-container invalid-feedback"></div>
                        </div>
                        @endif
                        <div class="col-md-12">
                            <!--begin::Label-->
                            @include('admin.__components.label', ['title' =>  'والد '])
                            <!--end::Label-->
                            <!--begin::Input-->

                            @include('admin.__components.select-2-ajax',
                                  [
                                  'title' => 'در صورت لزوم انتخاب کنید' ,
                                  'name' => 'parent' ,
                                  'url' => route('admin.categories.ajax.search',$entity) ,
                                  'selectedItems' => $category->parent()->get(['id', 'title']) ,
                                  ])
                            <!--end::Input-->
                            <!--begin::Description-->

                            <!--end::Description-->
                            <div class="fv-plugins-message-container invalid-feedback"></div>
                        </div>
                        <div class="col-md-12">
                            <!--begin::Label-->
                            <label class="required form-label">توضیحات دسته بندی </label>
                            <!--end::Label-->
                            <!--begin::Input-->
                            @include('admin.__components.textarea', [ 'name' => 'description' ,'value' => $category->description ])
                            <!--end::Input-->
                            <!--begin::Description-->
                            <!--end::Description-->
                            <div class="fv-plugins-message-container invalid-feedback"></div>
                        </div>
                    </div>
                </div>
                <!--end::Card header-->
            </div>
            <!--end::General options-->
            <!--begin::Automation-->
            <!--end::Automation-->
        </div>
        <!--end::Main column-->
        <!--begin::Aside column-->
        <div class="d-flex flex-column gap-7 gap-lg-10 w-100 w-lg-300px mb-7 me-lg-10">
            <!--begin::Status-->
            <div class="card card-flush py-4">
                <!--begin::Card header-->
                <div class="card-header">
                    <!--begin::Card title-->
                    <div class="card-title">
                        <h2>وضعیت</h2>
                    </div>
                    <!--end::Card title-->

                </div>
                <!--end::Card header-->
                <!--begin::Card body-->
                <div class="card-body pt-0">
                    <!--begin::Select2-->
                    @include('admin.__components.horizontal-radiobutton', [
                      'activeKey' => $category->status ,
                      'name' => 'status',
                      'items' => $activityStatuses
                      ])
                    <div class="d-none mt-10">
                        <label for="kt_ecommerce_add_category_status_datepicker" class="form-label">Select
                            publishing date and time</label>
                        <input class="form-control flatpickr-input" id="kt_ecommerce_add_category_status_datepicker"
                               placeholder="Pick date &amp; time" type="text" readonly="readonly">
                    </div>
                    <!--end::Datepicker-->
                </div>
                <!--end::Card body-->
            </div>
            <!--end::Status-->
            <!--begin::Thumbnail settings-->
            <div class="card card-flush">
                <!--begin::Card header-->
                <div class="card-header">
                    <!--begin::Card title-->
                    <div class="card-title">
                        <h4>تصویر</h4>
                    </div>
                    <!--end::Card title-->
                </div>
                <!--end::Card header-->
                <!--begin::Card body-->
                <div class="card-body text-center pt-0">
                    @include('admin.__components.image-input', [
                                'name' => 'avatar',
                                'imageUrl'=>$category->webPresent()->avatar
                                ])
                </div>
                <!--end::Card body-->
            </div>
            <div class="d-flex justify-content-end">


                <!--begin::Button-->
                <button type="submit" id="kt_ecommerce_add_category_submit" class="btn btn-primary">
                    <span class="indicator-label">ویرایش دسته بندی </span>

                </button>
                <!--end::Button-->
            </div>
            <!--end::Thumbnail settings-->
        </div>

        <!--end::Aside column-->
        <div></div>
    </form>
</div>
<!--end::Tables Widget 11-->
@endsection
@section('scripts')
    @include('admin.message.alert');
@endsection

