<!DOCTYPE html>

<html lang="en" >
<!--begin::Head-->
<head>
    <title>DataTables Subtable Examples by Keenthemes</title>
    <meta charset="utf-8"/>
    <meta name="description" content=""/>
    <meta name="keywords" content=""/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta property="og:locale" content="en_US" />
    <meta property="og:type" content="article" />
    <meta property="og:title" content="Metronic - Bootstrap 5 HTML, VueJS, React, Angular. Laravel, Asp.Net Core, Ruby on Rails, Spring Boot, Blazor, Django, Express.js, Node.js, Flask Admin Dashboard Theme & Template" />
    <meta property="og:url" content="https://keenthemes.com/metronic"/>
    <meta property="og:site_name" content="Keenthemes | Metronic" />
    <link rel="canonical" href=""/>
    <link rel="shortcut icon" href="/html/metronic/docs/assets/media/logos/metronic.ico"/>

    <!--begin::Fonts(mandatory for all pages)-->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700"/>        <!--end::Fonts-->

    <!--begin::Vendor Stylesheets(used for this page only)-->
    <link href="https://preview.keenthemes.com/html/metronic/docs/assets/plugins/custom/prismjs/prismjs.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="https://preview.keenthemes.com/html/metronic/docs/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
    <!--end::Vendor Stylesheets-->


    <!--begin::Global Stylesheets Bundle(mandatory for all pages)-->
    <link href="https://preview.keenthemes.com/html/metronic/docs/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="https://preview.keenthemes.com/html/metronic/docs/assets/css/style.bundle.css" rel="stylesheet" type="text/css"/>
    <!--end::Global Stylesheets Bundle-->

    <!--Begin::Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-5FS8GGP');</script>
    <!--End::Google Tag Manager -->
</head>
<!--end::Head-->

<!--begin::Body-->
<body >
<!--begin::Theme mode setup on page load-->
<script>
    var defaultThemeMode = "light";
    var themeMode;

    if ( document.documentElement ) {
        if ( document.documentElement.hasAttribute("data-bs-theme-mode")) {
            themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
        } else {
            if ( localStorage.getItem("data-bs-theme") !== null ) {
                themeMode = localStorage.getItem("data-bs-theme");
            } else {
                themeMode = defaultThemeMode;
            }
        }

        if (themeMode === "system") {
            themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
        }

        document.documentElement.setAttribute("data-bs-theme", themeMode);
    }
</script>
<!--end::Theme mode setup on page load-->


<!--begin::Main-->
<div class="d-flex flex-column flex-root">
    <!--begin::Page-->
    <div class="docs-page d-flex flex-row flex-column-fluid">
        <!--begin::Wrapper-->
        <div class="col-md-12" id="kt_docs_wrapper">
            <!--begin::Content-->
            <div class="docs-content d-flex flex-column flex-column-fluid" id="kt_docs_content">
                <!--begin::Container-->
                <div class="container d-flex flex-column flex-lg-row" id="kt_docs_content_container">
                    <!--begin::Card-->
                    <div class="card card-docs flex-row-fluid mb-2">
                        <!--begin::Card Body-->
                        <div class="card-body fs-6 py-15 px-10 py-lg-15 px-lg-15 text-gray-700">

                            <!--begin::Section-->
                            <div class="pt-10">
                                <!--begin::Heading-->
                                <h1 class="anchor fw-bold mb-5" id="subtable">
                                    <a href="#subtable"></a>
                                    Sub Datatable Example
                                </h1>
                                <!--end::Heading-->

                                <!--begin::Block-->
                                <div class="py-5">
                                    This example shows the DataTables table with an expandable row. The sub-rows data are generated by using DataTable's template methods with simple JS data objects that can either be generated locally or retrieved from an API endpoint.
                                </div>
                                <!--end::Block-->

                                <!--begin::Block-->
                                <div class="py-5">
                                    <table class="table align-middle table-row-dashed fs-6 gy-4" id="kt_docs_datatable_subtable">
                                        <!--begin::Table head-->
                                        <thead>
                                        <!--begin::Table row-->
                                        <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                                            <th class="min-w-100px">Order ID</th>
                                            <th class="text-end min-w-100px">Created</th>
                                            <th class="text-end min-w-150px">Customer</th>
                                            <th class="text-end min-w-100px">Total</th>
                                            <th class="text-end min-w-100px">Profit</th>
                                            <th class="text-end min-w-50px">Status</th>
                                            <th class="text-end"></th>
                                        </tr>
                                        <!--end::Table row-->
                                        </thead>
                                        <!--end::Table head-->


                                        <!--begin::Table body-->
                                        <tbody class="fw-bold text-gray-600">
                                        <!--begin::SubTable template-->
                                        <tr data-kt-docs-datatable-subtable="subtable_template" class="d-none">
                                            <td colspan="2">
                                                <div class="d-flex align-items-center gap-3">
                                                    <a href="#" class="symbol symbol-50px bg-secondary bg-opacity-25 rounded">
                                                        <img src="/html/metronic/docs/assets/media/stock/ecommerce/" alt="" data-kt-docs-datatable-subtable="template_image" />
                                                    </a>
                                                    <div class="d-flex flex-column text-muted">
                                                        <a href="#" class="text-dark text-hover-primary fw-bold" data-kt-docs-datatable-subtable="template_name">Product name</a>
                                                        <div class="fs-7" data-kt-docs-datatable-subtable="template_description">Product description</div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="text-end">
                                                <div class="text-dark fs-7">Cost</div>
                                                <div class="text-muted fs-7 fw-bold" data-kt-docs-datatable-subtable="template_cost">1</div>
                                            </td>
                                            <td class="text-end">
                                                <div class="text-dark fs-7">Qty</div>
                                                <div class="text-muted fs-7 fw-bold" data-kt-docs-datatable-subtable="template_qty">1</div>
                                            </td>
                                            <td class="text-end">
                                                <div class="text-dark fs-7">Total</div>
                                                <div class="text-muted fs-7 fw-bold" data-kt-docs-datatable-subtable="template_total">name</div>
                                            </td>
                                            <td class="text-end">
                                                <div class="text-dark fs-7 me-3">On hand</div>
                                                <div class="text-muted fs-7 fw-bold" data-kt-docs-datatable-subtable="template_stock">32</div>
                                            </td>
                                            <td></td>
                                        </tr>
                                        <!--end::SubTable template-->
                                        <tr>

                                            <!--begin::Order ID-->
                                            <td>
                                                <a href="#" class="text-dark text-hover-primary">#XGT-346</a>
                                            </td>
                                            <!--end::Order ID-->

                                            <!--begin::Crated date-->
                                            <td class="text-end">
                                                13 February 2023, 8:54 am						</td>
                                            <!--end::Created date-->

                                            <!--begin::Customer-->
                                            <td class="text-end">
                                                <a href="" class="text-dark text-hover-primary">Emma Smith</a>
                                            </td>
                                            <!--end::Customer-->

                                            <!--begin::Total-->
                                            <td class="text-end">
                                                $630.00						</td>
                                            <!--end::Total-->

                                            <!--begin::Profit-->
                                            <td class="text-end">
                                                <span class="text-dark fw-bold">$86.70</span>
                                            </td>
                                            <!--end::Profit-->

                                            <!--begin::Status-->
                                            <td class="text-end">
                                                <span class="badge py-3 px-4 fs-7 badge-light-warning">Pending</span>
                                            </td>
                                            <!--end::Status-->

                                            <!--begin::Actions-->
                                            <td class="text-end">
                                                <button type="button" class="btn btn-sm btn-icon btn-light btn-active-light-primary toggle h-25px w-25px" data-kt-docs-datatable-subtable="expand_row">
                                                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr087.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-off"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect opacity="0.5" x="11" y="18" width="12" height="2" rx="1" transform="rotate(-90 11 18)" fill="currentColor"/>
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg></span>
                                                    <!--end::Svg Icon-->								<!--begin::Svg Icon | path: icons/duotune/arrows/arr089.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-on"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg>
</span>
                                                    <!--end::Svg Icon-->							</button>
                                            </td>
                                            <!--end::Actions-->
                                        </tr>
                                        <tr>

                                            <!--begin::Order ID-->
                                            <td>
                                                <a href="#" class="text-dark text-hover-primary">#YHD-047</a>
                                            </td>
                                            <!--end::Order ID-->

                                            <!--begin::Crated date-->
                                            <td class="text-end">
                                                13 February 2023, 8:02 am						</td>
                                            <!--end::Created date-->

                                            <!--begin::Customer-->
                                            <td class="text-end">
                                                <a href="" class="text-dark text-hover-primary">Melody Macy</a>
                                            </td>
                                            <!--end::Customer-->

                                            <!--begin::Total-->
                                            <td class="text-end">
                                                $25.00						</td>
                                            <!--end::Total-->

                                            <!--begin::Profit-->
                                            <td class="text-end">
                                                <span class="text-dark fw-bold">$4.20</span>
                                            </td>
                                            <!--end::Profit-->

                                            <!--begin::Status-->
                                            <td class="text-end">
                                                <span class="badge py-3 px-4 fs-7 badge-light-primary">Confirmed</span>
                                            </td>
                                            <!--end::Status-->

                                            <!--begin::Actions-->
                                            <td class="text-end">
                                                <button type="button" class="btn btn-sm btn-icon btn-light btn-active-light-primary toggle h-25px w-25px" data-kt-docs-datatable-subtable="expand_row">
                                                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr087.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-off"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect opacity="0.5" x="11" y="18" width="12" height="2" rx="1" transform="rotate(-90 11 18)" fill="currentColor"/>
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg></span>
                                                    <!--end::Svg Icon-->								<!--begin::Svg Icon | path: icons/duotune/arrows/arr089.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-on"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg>
</span>
                                                    <!--end::Svg Icon-->							</button>
                                            </td>
                                            <!--end::Actions-->
                                        </tr>
                                        <tr>

                                            <!--begin::Order ID-->
                                            <td>
                                                <a href="#" class="text-dark text-hover-primary">#SRR-678</a>
                                            </td>
                                            <!--end::Order ID-->

                                            <!--begin::Crated date-->
                                            <td class="text-end">
                                                13 February 2023, 4:54 am						</td>
                                            <!--end::Created date-->

                                            <!--begin::Customer-->
                                            <td class="text-end">
                                                <a href="" class="text-dark text-hover-primary">Max Smith</a>
                                            </td>
                                            <!--end::Customer-->

                                            <!--begin::Total-->
                                            <td class="text-end">
                                                $1,630.00						</td>
                                            <!--end::Total-->

                                            <!--begin::Profit-->
                                            <td class="text-end">
                                                <span class="text-dark fw-bold">$203.90</span>
                                            </td>
                                            <!--end::Profit-->

                                            <!--begin::Status-->
                                            <td class="text-end">
                                                <span class="badge py-3 px-4 fs-7 badge-light-warning">Pending</span>
                                            </td>
                                            <!--end::Status-->

                                            <!--begin::Actions-->
                                            <td class="text-end">
                                                <button type="button" class="btn btn-sm btn-icon btn-light btn-active-light-primary toggle h-25px w-25px" data-kt-docs-datatable-subtable="expand_row">
                                                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr087.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-off"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect opacity="0.5" x="11" y="18" width="12" height="2" rx="1" transform="rotate(-90 11 18)" fill="currentColor"/>
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg></span>
                                                    <!--end::Svg Icon-->								<!--begin::Svg Icon | path: icons/duotune/arrows/arr089.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-on"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg>
</span>
                                                    <!--end::Svg Icon-->							</button>
                                            </td>
                                            <!--end::Actions-->
                                        </tr>
                                        <tr>

                                            <!--begin::Order ID-->
                                            <td>
                                                <a href="#" class="text-dark text-hover-primary">#PXF-534</a>
                                            </td>
                                            <!--end::Order ID-->

                                            <!--begin::Crated date-->
                                            <td class="text-end">
                                                12 February 2023, 8:54 am						</td>
                                            <!--end::Created date-->

                                            <!--begin::Customer-->
                                            <td class="text-end">
                                                <a href="" class="text-dark text-hover-primary">Sean Bean</a>
                                            </td>
                                            <!--end::Customer-->

                                            <!--begin::Total-->
                                            <td class="text-end">
                                                $119.00						</td>
                                            <!--end::Total-->

                                            <!--begin::Profit-->
                                            <td class="text-end">
                                                <span class="text-dark fw-bold">$12.00</span>
                                            </td>
                                            <!--end::Profit-->

                                            <!--begin::Status-->
                                            <td class="text-end">
                                                <span class="badge py-3 px-4 fs-7 badge-light-success">Shipped</span>
                                            </td>
                                            <!--end::Status-->

                                            <!--begin::Actions-->
                                            <td class="text-end">
                                                <button type="button" class="btn btn-sm btn-icon btn-light btn-active-light-primary toggle h-25px w-25px" data-kt-docs-datatable-subtable="expand_row">
                                                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr087.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-off"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect opacity="0.5" x="11" y="18" width="12" height="2" rx="1" transform="rotate(-90 11 18)" fill="currentColor"/>
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg></span>
                                                    <!--end::Svg Icon-->								<!--begin::Svg Icon | path: icons/duotune/arrows/arr089.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-on"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg>
</span>
                                                    <!--end::Svg Icon-->							</button>
                                            </td>
                                            <!--end::Actions-->
                                        </tr>
                                        <tr>

                                            <!--begin::Order ID-->
                                            <td>
                                                <a href="#" class="text-dark text-hover-primary">#XGD-249</a>
                                            </td>
                                            <!--end::Order ID-->

                                            <!--begin::Crated date-->
                                            <td class="text-end">
                                                11 February 2023, 8:54 am						</td>
                                            <!--end::Created date-->

                                            <!--begin::Customer-->
                                            <td class="text-end">
                                                <a href="" class="text-dark text-hover-primary">Brian Cox</a>
                                            </td>
                                            <!--end::Customer-->

                                            <!--begin::Total-->
                                            <td class="text-end">
                                                $660.00						</td>
                                            <!--end::Total-->

                                            <!--begin::Profit-->
                                            <td class="text-end">
                                                <span class="text-dark fw-bold">$52.26</span>
                                            </td>
                                            <!--end::Profit-->

                                            <!--begin::Status-->
                                            <td class="text-end">
                                                <span class="badge py-3 px-4 fs-7 badge-light-success">Shipped</span>
                                            </td>
                                            <!--end::Status-->

                                            <!--begin::Actions-->
                                            <td class="text-end">
                                                <button type="button" class="btn btn-sm btn-icon btn-light btn-active-light-primary toggle h-25px w-25px" data-kt-docs-datatable-subtable="expand_row">
                                                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr087.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-off"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect opacity="0.5" x="11" y="18" width="12" height="2" rx="1" transform="rotate(-90 11 18)" fill="currentColor"/>
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg></span>
                                                    <!--end::Svg Icon-->								<!--begin::Svg Icon | path: icons/duotune/arrows/arr089.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-on"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg>
</span>
                                                    <!--end::Svg Icon-->							</button>
                                            </td>
                                            <!--end::Actions-->
                                        </tr>
                                        <tr>

                                            <!--begin::Order ID-->
                                            <td>
                                                <a href="#" class="text-dark text-hover-primary">#SKP-035</a>
                                            </td>
                                            <!--end::Order ID-->

                                            <!--begin::Crated date-->
                                            <td class="text-end">
                                                10 February 2023, 8:54 am						</td>
                                            <!--end::Created date-->

                                            <!--begin::Customer-->
                                            <td class="text-end">
                                                <a href="" class="text-dark text-hover-primary">Brian Cox</a>
                                            </td>
                                            <!--end::Customer-->

                                            <!--begin::Total-->
                                            <td class="text-end">
                                                $290.00						</td>
                                            <!--end::Total-->

                                            <!--begin::Profit-->
                                            <td class="text-end">
                                                <span class="text-dark fw-bold">$29.00</span>
                                            </td>
                                            <!--end::Profit-->

                                            <!--begin::Status-->
                                            <td class="text-end">
                                                <span class="badge py-3 px-4 fs-7 badge-light-danger">Rejected</span>
                                            </td>
                                            <!--end::Status-->

                                            <!--begin::Actions-->
                                            <td class="text-end">
                                                <button type="button" class="btn btn-sm btn-icon btn-light btn-active-light-primary toggle h-25px w-25px" data-kt-docs-datatable-subtable="expand_row">
                                                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr087.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-off"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect opacity="0.5" x="11" y="18" width="12" height="2" rx="1" transform="rotate(-90 11 18)" fill="currentColor"/>
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg></span>
                                                    <!--end::Svg Icon-->								<!--begin::Svg Icon | path: icons/duotune/arrows/arr089.svg-->
                                                    <span class="svg-icon svg-icon-3 m-0 toggle-on"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="6" y="11" width="12" height="2" rx="1" fill="currentColor"/>
</svg>
</span>
                                                    <!--end::Svg Icon-->							</button>
                                            </td>
                                            <!--end::Actions-->
                                        </tr>
                                        </tbody>
                                        <!--end::Table body-->
                                    </table>
                                </div>
                                <!--end::Block-->
                            </div>
                            <!--end::Section-->
                        </div>
                        <!--end::Card Body-->
                    </div>
                    <!--end::Card-->

                </div>
                <!--end::Container-->
            </div>
            <!--end::Content-->
        </div>
        <!--end::Wrapper-->
    </div>
    <!--end::Page-->
</div>
<!--end::Main-->
<!--begin::Javascript-->
<script>
    var hostUrl = "/html/metronic/docs/assets/";        </script>

<!--begin::Global Javascript Bundle(mandatory for all pages)-->
<script src="https://preview.keenthemes.com/html/metronic/docs/assets/plugins/global/plugins.bundle.js"></script>
<script src="https://preview.keenthemes.com/html/metronic/docs/assets/js/scripts.bundle.js"></script>
<script src="https://preview.keenthemes.com/html/metronic/docs/assets/js/custom/documentation/documentation.js"></script>
<script src="https://preview.keenthemes.com/html/metronic/docs/assets/js/custom/documentation/search.js"></script>
<!--end::Global Javascript Bundle-->

<!--begin::Vendors Javascript(used for this page only)-->
<script src="https://preview.keenthemes.com/html/metronic/docs/assets/plugins/custom/prismjs/prismjs.bundle.js"></script>
<script src="https://preview.keenthemes.com/html/metronic/docs/assets/plugins/custom/datatables/datatables.bundle.js"></script>
<!--end::Vendors Javascript-->

<!--begin::Custom Javascript(used for this page only)-->
<script src="https://preview.keenthemes.com/html/metronic/docs/assets/js/custom/documentation/general/datatables/subtable.js"></script>
<!--end::Custom Javascript-->
<!--end::Javascript-->

<!-- Start of LiveChat (www.livechat.com) code -->
<script>
    window.__lc = window.__lc || {};
    window.__lc.license = 14418225;
    ;(function(n,t,c){function i(n){return e._h?e._h.apply(null,n):e._q.push(n)}var e={_q:[],_h:null,_v:"2.0",on:function(){i(["on",c.call(arguments)])},once:function(){i(["once",c.call(arguments)])},off:function(){i(["off",c.call(arguments)])},get:function(){if(!e._h)throw new Error("[LiveChatWidget] You can't use getters before load.");return i(["get",c.call(arguments)])},call:function(){i(["call",c.call(arguments)])},init:function(){var n=t.createElement("script");n.async=!0,n.type="text/javascript",n.src="https://cdn.livechatinc.com/tracking.js",t.head.appendChild(n)}};!n.__lc.asyncInit&&e.init(),n.LiveChatWidget=n.LiveChatWidget||e}(window,document,[].slice))
</script>
<noscript><a href="https://www.livechat.com/chat-with/14418225/" rel="nofollow">Chat with us</a>, powered by <a href="https://www.livechat.com/?welcome" rel="noopener nofollow" target="_blank">LiveChat</a></noscript>
<!-- End of LiveChat code -->            </body>
<!--end::Body-->
</html>
