@extends('layouts.admin.admin')
@section('title',' مدیریت محصولات ها  ')
@section('pageTitle',' ثبت  محصول ')
@section('content')
    <div class="">
        <form class="form" action="{{route('admin.products.store')}}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <!--begin::Main column-->
                <div class="col-md-8">
                    <!--begin::General options-->
                    <div class="card card-flush py-4">
                        <!--begin::Card header-->
                        <div class="card-header">
                            <div class="card-title">
                                <h2>ثبت محصول جدید</h2>
                            </div>
                            <div class="card-toolbar">
                                <a href="{{route('admin.products.all')}}" class="btn btn-sm btn-light-success "
                                   style="margin-left: 5px">
                                    بازگشت
                                </a>

                            </div>
                        </div>
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body pt-0 mt-2">
                            <!--begin::Input group-->

                            <div class="row">
                                <div class="col-md-6">
                                    <div
                                        class="mb-10 fv-row fv-plugins-icon-container fv-plugins-bootstrap5-row-invalid">
                                        @include('admin.__components.label', [ 'title' => ' عنوان محصول'])
                                        @include('admin.__components.input-text', [
                                            'name' => 'title',

                                            ])
                                    </div>
                                </div>


                                <div class="col-md-6">
                                    <div
                                        class="mb-10 fv-row fv-plugins-icon-container fv-plugins-bootstrap5-row-invalid">
                                        @include('admin.__components.label', [ 'title' => 'تگ ها'])
                                        @include('admin.__components.select-2-ajax', [
                                            'name' => 'tags',
                                            'isMultiple' => true,
                                            'url' => route('admin.tags.search.ajax'),
                                            ])
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-10 fv-row fv-plugins-icon-container">
                                        @include('admin.__components.label',['title' => 'توضیحات کوتاه','required' => true])
                                        <div class="mb-5">
                                            @include('admin.__components.textarea', [
                                                    'name' => 'short_description',
                                                    ])
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-10 fv-row fv-plugins-icon-container">
                                        @include('admin.__components.label',['title' => 'توضیحات','required' => true])
                                        <div class="mb-5">
                                            @include('admin.__components.ckeditor', [
                                                    'name' => 'description',
                                                    ])
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--end::Card header-->

                        <div class="card-footer d-flex flex-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-plus"></i>
                                <span class="indicator-label">ثبت محصول</span>
                            </button>
                        </div>
                    </div>
                    <!--end::General options-->
                </div>
                <!--end::Main column-->
                <!--begin::Aside column-->
                <div class="mb-7 col-md-4">
                    <!--begin::Status-->
                    <div class="card card-flush py-4 mb-5">
                        <!--begin::Card header-->
                        <div class="card-header">
                            <!--begin::Card title-->
                            <div class="card-title">
                                <h2>وضعیت<span class="text-danger text-bold px-2" style="font-size: 14px">*</span></h2>
                            </div>
                            <!--end::Card title-->
                        </div>
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body pt-0">
                            <!--begin::Select2-->
                            @include('admin.__components.horizontal-radiobutton', [
                             'activeKey' => $statuses[0]['id'] ,
                             'name' => 'status',
                             'items' => $statuses
                              ])
                        </div>
                    </div>

                    <div class="card card-flush py-4 mb-5">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>تصویر</h2>
                            </div>
                        </div>
                        <div class="card-body text-center pt-0">
                            @include('admin.__components.image-input', [ 'name' => 'image'])
                        </div>
                    </div>

                    <div class="card card-flush py-4 mb-5">
                        <div class="card-header">
                            <div class="card-title">
                                <h2>دسته بندی </h2>
                            </div>
                        </div>
                        <div class="card-body text-center pt-0">
                            @include('admin.__components.jsTree', [
                            'name' => 'categories',
                            'items' => $categories,
                            'isMultiple' => true,
                             ])
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('scripts')
    <script>

        // load select 2 for select Roles :

        $('#roles').select2({
            placeholder: 'نقش کاربر را انتخاب نمایید',
        });

        // load select 2 for select Permissions :

        $('#permissions').select2({
            dir: 'RTL',
            placeholder: 'مجوزهای کاربر را انتخاب نمایید',
            tags: true
        });

        $('#admins').select2({
            placeholder: '\ کاربر را انتخاب نمایید',
        });


    </script>
@endsection

@section('style')

    <link rel="stylesheet" href="{{asset('admin-assets/plugins/custom/jstree/jstree.bundle.rtl.css')}}"/>
@endsection
@section('top-scripts')

    <script src="{{asset('admin-assets/plugins/custom/jstree/jstree.bundle.js')}}"></script>
@endsection
