@extends('layouts.admin.admin')
@section('content')
    @include('admin.products.index',[
        'active' =>'gallery'
])
    <div id="kt_content_container" class="container-xxl">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-flush py-4">
                    <!--begin::Card header-->
                    <div class="card-header">
                        <div class="card-title">
                            <h2>گالری پست</h2>
                        </div>
                    </div>
                    <!--end::Card header-->
                    <!--begin::Card body-->
                    <div class="card-body pt-0">
                        <!--begin::Input group-->
                        <!--begin::Card toolbar-->              <div class="fv-row mb-2">
                            <!--begin::Dropzone-->
                            <form method="post" action="{{route("admin.products.upload-gallery",$product)}}"
                                  enctype="multipart/form-data" class="dropzone" id="dropzone">
                                @csrf
                                <div class="dropzone dz-clickable" id="kt_ecommerce_add_product_media">
                                    <!--begin::Message-->
                                    <div class="dz-message needsclick">
                                        <!--begin::Icon-->
                                        <i class="bi bi-file-earmark-arrow-up text-primary fs-3x"></i>
                                        <!--end::Icon-->
                                        <!--begin::Info-->
                                        <div class="ms-4">
                                            <h3 class="fs-5 fw-bold text-gray-900 mb-1">فایل ها را اینجا رها کنید یا برای
                                                آپلود کلیک کنید.</h3>
                                            <span
                                                class="fs-7 fw-semibold text-gray-400">همزمان مجاز به اپلود 3 فایل هستید</span>
                                        </div>
                                        <!--end::Info-->
                                    </div>
                                </div>
                            </form>

                            <!--end::Dropzone-->
                        </div>
                        <!--end::Input group-->
                        <!--begin::Description-->
                        <div class="text-muted fs-7">گالری رسانه محصول را تنظیم کنید.</div>
                        <br/>
                        <br/>
                        <div class="text-muted fs-7">
                            <a href="{{route('admin.products.gallery',$product)}}" id="kt_ecommerce_add_category_submit"
                               class="btn btn-primary">
                                <span class="indicator-label">ثبت اطلاعات  </span>

                            </a>
                        </div>
                        <!--end::Description-->
                    </div>
                    <!--end::Card header-->
                </div>
            </div>

        </div>
        <br/>
        <div class="row">
        <div class="col-md-12">
            <div class="card" data-select2-id="select2-data-131-rhmf">
                <div class="card-header border-0 pt-5">
                    <h3 class="card-title align-items-start flex-column">
                        <span class="card-label fw-bolder fs-3 mb-1"> فهرست گالری </span>
                    </h3>

                </div>
                <!--begin::Card body-->
                <div class="card-body pt-0">

                    <!--begin::Table-->
                    <div id="kt_customers_table_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                        <div class="table-responsive">
                            <table class="table align-middle table-row-dashed fs-6 gy-5 dataTable no-footer"
                                   id="kt_customers_table">
                                <!--begin::Table head-->
                                <thead>
                                <!--begin::Table row-->
                                <tr class="min-w-125px sorting">

                                    <th class="min-w-125px sorting" tabindex="0" aria-controls="kt_customers_table"
                                        rowspan="1"
                                        colspan="1" style="width: 162.9px;"
                                        aria-label="Customer Name: activate to sort column ascending"> تصویر
                                    </th>
                                    <th class="min-w-125px sorting" rowspan="1" colspan="1"
                                        style="width: 162.9px;" aria-label="Actions">نوع گالری
                                    </th>
                                    <th class="min-w-125px sorting" rowspan="1" colspan="1"
                                        style="width: 162.9px;" aria-label="Actions">تنظیمات
                                    </th>
                                </tr>
                                <!--end::Table row-->
                                </thead>
                                <!--end::Table head-->
                                <!--begin::Table body-->
                                <tbody class="fw-bold text-gray-600">
                                @if($files->count() > 0)
                                    @foreach($files as $file)
                                        <tr class="odd">
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <!--begin:: Avatar -->
                                                    @if($file->type == \App\Constants\Constant::VIDEO)
                                                        <img src="{{asset('admin-assets/media/avatars/download.png')}}"
                                                             style="width:50px "/>
                                                        <a href="{{asset(\App\Constants\Constant::POSTS_GALLERY_PATH.$file->name)}}"
                                                           style="margin-right: 10px">نمایش ویدیو</a>
                                                    @else
                                                        <div
                                                            class="symbol symbol-circle symbol-50px overflow-hidden me-3">
                                                            <a href="#">
                                                                <div class="symbol-label">

                                                                    <img
                                                                        src="{{asset(\App\Constants\Constant::PRODUCT_GALLERY_PATH.$file->name)}}"
                                                                        alt="Ana Crown"
                                                                        class="w-100">
                                                                </div>
                                                            </a>
                                                        </div>
                                                    @endif
                                                    <!--end::Avatar-->
                                                </div>
                                            </td>
                                            <td> {!! $file->webPresent()->getType !!}</td>
                                            <td class="">

                                                <a data-id={{ $file->id }} href="javascript" class="btn btn-icon
                                                                        btn-light-danger btn-sm me-1 delete-confirm"
                                                   data-kt-customer-table-filter="delete_row">
                                                      <span class="svg-icon svg-icon-3">
                                                        <i class="fa fa-trash"></i>
                                                      </span>
                                                </a>

                                            </td>

                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="6" style="text-align:center;color:red"><a class="btn btn-danger"
                                                                                               href="">
                                                اطلاعات موجود نیست <i class="icon-warning2 mr-3 icon-1x"></i></a></td>
                                    </tr>
                                @endif
                                </tbody>
                                <!--end::Table body-->
                            </table>
                        </div>
                        <div class="row">
                            <div
                                class="col-sm-12 col-md-7 d-flex align-items-center justify-content-center justify-content-md-end">

                            </div>
                        </div>
                    </div>
                    <!--end::Table-->

                </div>
                <!--end::Card body-->
            </div>
        </div>
    </div>
    </div>
@endsection

@section('scripts')
    @include('admin.message.alert');
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.4.0/dropzone.js"></script>

    <script type="text/javascript">
        Dropzone.options.dropzone =
            {
                renameFile: function (file) {
                    var dt = new Date();
                    var time = dt.getTime();
                    return time + file.name;
                },
                addRemoveLinks: true,
                timeout: 50000,
                success: function (file, response) {
                },
                error: function (file, response) {
                    alert('خطا');
                }
            };
    </script>
    <script>

        $('.delete-confirm').on('click', function (event) {
            event.preventDefault();
            let gallery = $(this).data("id");
            let url = "{{ route('admin.products.delete-gallery',":gallery") }}";
            url = url.replace(":gallery", gallery);

            Swal.fire({
                title: 'حذف  !',
                text: "آیا مطمئن هستید ؟",
                icon: "error",
                showCancelButton: true,
                confirmButtonColor: 'red',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'بله,حذف کن',
                cancelButtonText: 'خیر',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>
@endsection

