@extends('layouts.admin.admin')
@section('title','قیمت گذاری محصولات ')
@section('pageTitle',' فهرست قیمت محصولات')
@section('content')
    @include('admin.products.index',[
       'active' =>'ProductUnitPrice'
])
    <form action="{{route('admin.products.ProductUnitPrice.store',$product)}}" method="post">
        @csrf

       <div class="row">
           <div class="col-md-4">
               {{-- انتخاب مقدار واحد --}}
               <select name="unit_value_id" class="form-control mb-3" required>
                   <option value="">انتخاب مقدار</option>
                   @foreach($unitValues as $value)
                       <option value="{{$value->id}}">
                           {{$value->unit->name}} - {{$value->title}}
                       </option>
                   @endforeach
               </select>
           </div>
           <div class="col-md-4">
               {{-- قیمت --}}
               <input type="number" name="price" class="form-control mb-3"
                      placeholder="قیمت" required>


           </div>
           <div class="col-md-4">
               {{-- موجودی --}}
               <input type="number" name="inventory" class="form-control mb-3"
                      placeholder="موجودی">

           </div>
           <div class="col-md-2">
               <button type="submit" class="btn btn-success">
                   ثبت قیمت
               </button>
           </div>
       </div>
    </form>
    <div class="card mt-4" data-select2-id="select2-data-131-rhmf">
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1"> فهرست قیمت محصول  </span>
            </h3>
        </div>
        <!--begin::Card body-->
        <div class="card-body pt-0">

            <!--begin::Table-->
            <div id="kt_customers_table_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                <div class="table-responsive">
                    <table class="table align-middle table-row-dashed fs-6 gy-5 dataTable no-footer">
                        <!--begin::Table head-->
                        <thead>
                        <!--begin::Table row-->
                        <tr class="min-w-125px sorting">
                            <th class="min-w-50px">
                                تصویر
                            </th>
                            <th class="min-w-100px sorting">عنوان محصول
                            </th>
                            <th class="min-w-100px sorting">واحد محصول
                            </th>
                            <th class="min-w-100px sorting">قیمت محصول
                            </th>
                            <th class="min-w-125px sorting">تعداد
                            </th>
                        </tr>
                        <!--end::Table row-->
                        </thead>
                        <!--end::Table head-->
                        <!--begin::Table body-->
                        <tbody class="fw-bold text-gray-600">

                        @if($prices->count() > 0)
                            @foreach($prices as $price)

                                <tr class="odd">
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <!--begin:: Avatar -->
                                            <div class="symbol symbol-circle symbol-50px overflow-hidden me-3">
                                                <a href="#">
                                                    <div class="symbol-label">
                                                        <img src="{{asset($price->product->webPresent()->image)}}"
                                                             alt="Ana Crown"
                                                             class="w-100">
                                                    </div>
                                                </a>
                                            </div>
                                            <!--end::Avatar-->

                                        </div>
                                    </td>
                                    <td>{!! $price->product->title!!}</td>
                                    <td>{!! $price->unitValue->title!!}</td>
                                    <td> {{number_format($price->price) .' ' .' تومان'}} </td>
                                    <td>{!! $price->inventory!!}</td>



                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="6" style="text-align:center;color:red"><a class="btn btn-danger" href="">
                                        اطلاعات موجود نیست <i class="icon-warning2 mr-3 icon-1x"></i></a></td>
                            </tr>
                        @endif
                        </tbody>
                        <!--end::Table body-->
                    </table>
                </div>
                <div class="row">
                    <div
                        class="col-sm-12 col-md-7 d-flex align-items-center justify-content-center justify-content-md-end">

                    </div>
                </div>
            </div>
            <!--end::Table-->
        </div>
        <!--end::Card body-->
    </div>
@endsection
@section('scripts')
    @include('admin.message.alert');
    <script>
        $('#remove-empty-values').submit(function () {
            $(this).find(':input').filter(function () {
                return !this.value;
            }).attr('disabled', 'disabled');
            return true;
        });
    </script>
    <script>

        $('.delete-confirm').on('click', function (event) {
            event.preventDefault();
            let post_id = $(this).data("id");
            let url = "{{ route('admin.posts.delete',":post_id") }}";
            url = url.replace(":post_id", post_id);

            Swal.fire({
                title: 'حذف  !',
                text: "آیا مطمئن هستید ؟",
                icon: "error",
                showCancelButton: true,
                confirmButtonColor: 'red',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'بله,حذف کن',
                cancelButtonText: 'خیر',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>

@endsection
