
@extends('layouts.admin.admin')

@section('title','مدیریت مقادیر واحد')
@section('pageTitle','فهرست مقادیر واحد')

@section('content')

    <div class="row">
        <div class="col-md-4">
            <form action="{{route('admin.UnitsValue.store')}}" method="post">
                @csrf
                <div class="card mb-5 mb-xl-8">

                    <div class="card-header border-0 pt-5">
                        <h3 class="card-title fw-bolder fs-3">
                            ثبت مقدار واحد
                        </h3>
                    </div>

                    <div class="card-body py-3">

                        {{-- انتخاب واحد --}}
                        <div class="col-md-12">
                            @include('admin.__components.label', ['title' => 'واحد','required'=>1])
                            <div class="mb-5">
                                <select class="form-control" name="unit_id" required>
                                    <option value="">انتخاب کنید</option>
                                    @foreach($units as $unit)
                                        <option value="{{$unit->id}}">
                                            {{$unit->name}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        {{-- عنوان --}}
                        <div class="col-md-12">
                            @include('admin.__components.label', ['title'=>'عنوان','required'=>1])
                            <div class="mb-5">
                                @include('admin.__components.input-text', [
                                    'name'=>'title',
                                    'placeholder'=>'مثلا 10 گرم'
                                ])
                            </div>
                        </div>

                        {{-- مقدار عددی --}}
                        <div class="col-md-12">
                            @include('admin.__components.label', ['title'=>'مقدار عددی'])
                            <div class="mb-5">
                                <input type="number" step="0.001" name="value" class="form-control"
                                       placeholder="مثلا 10 یا 1000">
                                <small class="text-muted">
                                    برای تعداد خالی بگذارید
                                </small>
                            </div>
                        </div>

                    </div>

                    <div class="card-footer text-end">
                        <button type="submit" class="btn btn-light-success">
                            <i class="fa fa-plus"></i>
                            ثبت مقدار
                        </button>
                    </div>

                </div>
            </form>
        </div>

        {{-- لیست --}}
        <div class="col-md-8">
            <div class="card mb-5 mb-xl-8">

                <div class="card-header border-0 pt-5">
                    <h3 class="card-title fw-bolder fs-3">
                        فهرست مقادیر واحد
                    </h3>
                </div>

                <div class="card-body py-3">
                    <div class="table-responsive">
                        <table class="table align-middle gy-4">
                            <thead>
                            <tr class="fw-bolder text-muted bg-light">
                                <th>#</th>
                                <th>واحد</th>
                                <th>عنوان</th>
                                <th>مقدار</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            @forelse($unitValues as $item)
                                <tr>
                                    <td>{{$item->id}}</td>
                                    <td>{{$item->unit->name}}</td>
                                    <td>{{$item->title}}</td>
                                    <td>
                                        {{$item->value ?? '-'}}
                                    </td>
                                    <td>
                                        <a data-id="{{$item->id}}"
                                           class="btn btn-light-danger btn-sm delete-confirm">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center text-danger">
                                        اطلاعاتی ثبت نشده است
                                    </td>
                                </tr>
                            @endforelse

                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>

@endsection
@section('scripts')
    <!--Begin : SweetAlert Flash Messages -->
    <script>
        // success message
        @if((session('success')))
        Swal.fire({
            icon: 'success',
            title: 'عملیات موفق',
            text: "{{ (session('success'))}}",
            confirmButtonText: "متوجه شدم"
        })
        @endif
        // error message
        @if((session('failed')))
        Swal.fire({
            icon: 'error',
            title: 'خطا',
            text: "{{session('failed')}}",
            confirmButtonText: "متوجه شدم"
        })
        @endif
    </script>
    <!--End : SweetAlert Flash Messages -->


    <script>
        $('.delete-confirm').on('click', function (event) {
            event.preventDefault();
            let id = $(this).data("id");
            let url = "{{ route('admin.UnitsValue.delete',":id") }}";
            url = url.replace(":id", id);

            Swal.fire({
                title: 'حذف  !',
                text: "آیا مطمئن هستید ؟",
                icon: "error",
                showCancelButton: true,
                confirmButtonColor: 'red',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'بله,حذف کن',
                cancelButtonText: 'خیر',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>

@endsection
