@extends('layouts.app.auth')
@section('title',' ایجاد حساب کاربری ')
@section('content')
    <div class="bg-background bg-dot-rgba(1,1,1,0.1) dark:bg-dot-rgba(254,254,255,0.1) relative flex min-h-screen w-full items-center justify-center overflow-x-hidden">
        <div class="bg-background pointer-events-none absolute inset-0 flex items-center justify-center [mask-image:radial-gradient(ellipse_at_center,transparent_80%,black)] lg:[mask-image:radial-gradient(ellipse_at_center,transparent_20%,black)]"></div>
        <!-- background -->
        <div class="pointer-events-none absolute inset-0 flex w-screen items-center justify-center overflow-hidden [mask-image:radial-gradient(transparent_15%,white)]">
            <svg class="absolute left-0 top-0 h-full w-full stroke-black/10 stroke-[2] [mask-image:linear-gradient(transparent_15%,white,transparent_85%)] dark:stroke-white/10" data-n-ids='{"1a4MN34vH0:0":"1a4MN34vH0:0"}'>
                <rect width="100%" height="100%" stroke-width="0" fill="url(#grid-pattern-1a4MN34vH0:0)"></rect>
                <svg>
                    <rect stroke-width="0" width="95" height="95" x="97" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="385" y="193" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="193" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="673" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="481" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="1249" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="1" y="481"></rect>
                    <rect stroke-width="0" width="95" height="95" x="577" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="1057" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" y="481"></rect>
                    <rect stroke-width="0" width="95" height="95" x="1249" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                </svg>
                <defs>
                    <pattern id="grid-pattern-1a4MN34vH0:0" viewBox="0 0 64 64" height="96" patternUnits="userSpaceOnUse">
                        <path d="M64 0H0V64" fill="none"></path>
                    </pattern>
                </defs>
            </svg>

            <svg width="1512" height="1714" viewBox="0 0 1512 1714" fill="none" xmlns="http://www.w3.org/2000/svg" class="pointer-events-none absolute left-0 top-0 h-auto w-full lg:w-1/2">
                <g clip-path="url(#clip0_143_13)">
                    <g filter="url(#filter0_f_143_13)">
                        <path
                            d="M1045.18 982.551C1129.83 903.957 204.996 477.237 -235.529 294L-339.645 584.211C59.2367 752.376 960.521 1061.15 1045.18 982.551Z"
                            fill="white"
                            fill-opacity="0.15"
                        ></path>
                    </g>
                </g>
                <defs>
                    <filter id="filter0_f_143_13" x="-595.645" y="38" width="1902.26" height="1213.13" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                        <feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
                        <feBlend
                            mode="normal"
                            in="SourceGraphic"
                            in2="BackgroundImageFix"
                            result="shape"
                        ></feBlend>
                        <feGaussianBlur
                            stdDeviation="64"
                            result="effect1_foregroundBlur_143_13"
                        ></feGaussianBlur>
                    </filter>
                    <clipPath id="clip0_143_13">
                        <rect width="1512" height="1714" fill="white"></rect>
                    </clipPath>
                </defs>
            </svg>
        </div>
        <div class="absolute left-2 top-2">
            <button onclick="toggleDark(event)" class="icon-btn h-10 w-10">
                <i class="i-carbon-moon dark:i-carbon-sun !h-6 !w-6"></i>
            </button>
        </div>

        <div class="xs:container z-10 w-full py-10">
            <div
                class="xs:max-w-[440px] xs:rounded-xl bg-muted relative mx-auto px-4 py-8 lg:px-10 lg:py-12"
            >
                <!-- Return previous Section -->
                <a
                    href="{{route('app.index')}}"
                    class="xs:-top-2 xs:-right-2 bg-background hover:bg-primary-btn hover:text-background text-primary absolute right-2 top-2 flex size-10 items-center justify-center rounded-full border duration-300"
                >
                    <i class="i-carbon-chevron-right size-7 stroke-2"></i>
                </a>
                <form class="flex flex-col" action="{{route('auth.app.register')}}" method="post">
                    @csrf

                    <a href="{{route('app.index')}}" class="mb-10">
                        فروشگاه فوتپا
                    </a>

                    <h1 class="xs:text-lg mb-8 text-center font-medium">
                       ایجاد حساب کاربری
                    </h1>

                    <!-- password -->
                    <div class="mb-4 w-full space-y-3">
                        <span style="font-size: 13px;margin-bottom: 5px">نام و نام خانوادگی</span>
                        <label for="password" class="focus-within:border-primary bg-muted relative block w-full rounded-lg border shadow-sm duration-300">
                            <input
                                dir="ltr"
                                type="text"
                                id="full_name"
                                name="full_name"
                                class="xs:p-4 peer w-full rounded-lg bg-transparent p-3 text-left placeholder-transparent outline-none focus:ring-0"
                            />

                        </label>
                        <br/>
                        <span style="font-size: 13px;margin-bottom: 5px"> شماره موبایل خودرا وارد کنید</span>
                        <label for="password" class="focus-within:border-primary bg-muted relative block w-full rounded-lg border shadow-sm duration-300">
                            <input
                                dir="ltr"
                                type="text"
                                id="mobile"
                                name="mobile"
                                class="xs:p-4 peer w-full rounded-lg bg-transparent p-3 text-left placeholder-transparent outline-none focus:ring-0"
                            />

                        </label>
                        <br/>
                        <span style="font-size: 13px;margin-bottom: 5px"> رمز عبور خودرا وارد کنید</span>

                        <label for="password" class="focus-within:border-primary bg-muted relative block w-full rounded-lg border shadow-sm duration-300">
                            <input
                                dir="ltr"
                                type="password"
                                id="password"
                                name="password"
                                class="xs:p-4 peer w-full rounded-lg bg-transparent p-3 text-left placeholder-transparent outline-none focus:ring-0"
                            />

                        </label>
                        <p class="text-warning h-5 text-sm">
                            <!-- لطفا این قسمت را خالی نگذارید -->
                        </p>
                    </div>
                    <ul class="mb-6 space-y-4">
                        <li>
                            <a
                                href="{{route('auth.app.login.form')}}"
                                class="text-primary hover:text-primary/80 flex items-center gap-1 text-sm duration-200"
                            >
                                حساب کاربری دارید ! ورود به حساب کاربری
                                <i class="i-carbon-chevron-left size-4"></i>
                            </a>
                        </li>

                    </ul>

                    <button class="btn-primary py-3"> ایجاد حساب کاربری  </button>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('scripts')



    <script>
        @if(session()->has('failed'))

        Swal.fire({
            icon: 'error',
            confirmButtonText :  'متوجه شدم',
            title: 'خطا! ',
            text: '{{ session()->get('error') }}',
        });
        @endif
    </script>
@endsection
